uniform mat4	prevWTM;

uniform vec2	tscale0;
uniform vec2	tscale1;
uniform vec2	tscale2;
uniform vec2	tscale3;

uniform vec2	tofs0;		// cambiare in uniform
uniform vec2	tofs1;		// cambiare in uniform
uniform vec2	tofs2;
uniform vec2	tofs3;

////////////////////////////
varying float 	slope;
varying vec2 	texcoord;
varying vec2 	texcoord1;
varying vec2 	texcoord2;
varying vec2 	texcoord3;

varying vec2 	texcoord4;
varying vec2 	texcoord5;
varying mat3	TBN;
//////

attribute vec3 			s2_vertex;
attribute vec3			s2_normal;
attribute vec4			s2_binormal;
attribute vec4 			s2_color;
attribute vec4 			s2_secondaryColor;
attribute vec4			s2_texcoords; 

void main()
{  
	vec4 vertex=vec4(s2_vertex,1.0);

	vec4 normal4   	= vec4( s2_normal, 0.0 );
	vec4 binormal4  = vec4( s2_binormal.xyz, 0.0 );
	vec4 tangent4   = vec4(cross(binormal4.xyz,normal4.xyz),0.0);
	binormal4.xyz*=s2_binormal.w;

	slope=s2_normal.y;//pow(abs(min(s2_normal.y+0.05,1.0)),2.0);
	
	vec2	cscale0=tscale0,
			cscale1=tscale1,
			cscale2=tscale2,
			cscale3=tscale3;
			
	/*if((1.0-slope)>0.1)
	{
		cscale0.y/=4.0;
		cscale1.y/=4.0;
		cscale2.y/=4.0;
		cscale3.y/=4.0;
	}*/
	
	vec4 	outTangent,
			outNormal,
			outBinormal;
		
	outNormal=prevWTM*normal4;
	outTangent=prevWTM*tangent4;
	outBinormal=prevWTM*binormal4;

	TBN[0]=outTangent.xyz;
	TBN[1]=outBinormal.xyz;
	TBN[2]=outNormal.xyz;
	
	texcoord = s2_texcoords.st*cscale0 + tofs0;
	texcoord1 = s2_texcoords.st*cscale1 + tofs1;
	texcoord2 = s2_texcoords.st*cscale2 + tofs2;
	texcoord3 = s2_texcoords.st*cscale3 + tofs3;
	
	texcoord4 = s2_texcoords.st*vec2(1.0,tscale3.y) + tofs3*2.0;
	texcoord5 = s2_texcoords.st*vec2(1.0,tscale1.y) + tofs1*2.0;
	
	gl_Position = (gl_ModelViewProjectionMatrix)*vertex;
}